/*
 * Decompiled with CFR 0.152.
 */
package com.uraneptus.snowpig.common.entities;

import com.uraneptus.snowpig.core.registry.EntityTypeRegistry;
import com.uraneptus.snowpig.core.registry.SoundRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.BoostHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.IRideable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.network.NetworkHooks;

public class SnowPigEntity
extends AnimalEntity
implements IRideable,
IEquipable {
    private static final DataParameter<Boolean> DATA_SADDLE_ID = EntityDataManager.func_187226_a(PigEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DATA_BOOST_TIME = EntityDataManager.func_187226_a(PigEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Ingredient FOOD_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151172_bF, Items.field_151174_bG, Items.field_185164_cV});
    private final BoostHelper steering;
    public static final ResourceLocation FROZEN_HAM_LOOT = new ResourceLocation("snowpig", "entities/mod_integration/frozen_ham_loot");

    public SnowPigEntity(EntityType<? extends SnowPigEntity> snowpig, World worldIn) {
        super(snowpig, worldIn);
        this.steering = new BoostHelper(this.field_70180_af, DATA_BOOST_TIME, DATA_SADDLE_ID);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151146_bM}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, false, FOOD_ITEMS));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, 0.15).func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233820_c_, 0.3).func_233815_a_(Attributes.field_233826_i_, 0.5);
    }

    public static boolean canSpawn(EntityType<SnowPigEntity> entityType, IServerWorld world, SpawnReason reason, BlockPos pos, Random random) {
        return world.func_226659_b_(pos, 0) > 8;
    }

    public ResourceLocation func_184647_J() {
        if (ModList.get().isLoaded("farmersdelight")) {
            return FROZEN_HAM_LOOT;
        }
        return this.func_200600_R().func_220348_g();
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity playerentity = (PlayerEntity)entity;
        return playerentity.func_184614_ca().func_77973_b() == Items.field_151146_bM || playerentity.func_184592_cb().func_77973_b() == Items.field_151146_bM;
    }

    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (DATA_BOOST_TIME.equals(p_184206_1_) && this.field_70170_p.field_72995_K) {
            this.steering.func_233616_a_();
        }
        super.func_184206_a(p_184206_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_SADDLE_ID, (Object)false);
        this.field_70180_af.func_187214_a(DATA_BOOST_TIME, (Object)0);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        this.steering.func_233618_a_(p_213281_1_);
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.steering.func_233621_b_(p_70037_1_);
    }

    protected float func_70599_aP() {
        return 0.3f;
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)SoundRegistry.SNOW_PIG_AMBIENT.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)SoundRegistry.SNOW_PIG_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SoundRegistry.SNOW_PIG_DEATH.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a((SoundEvent)SoundRegistry.SNOW_PIG_STEP.get(), 0.1f, 1.0f);
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        boolean flag = this.func_70877_b(p_230254_1_.func_184586_b(p_230254_2_));
        if (!flag && this.func_110257_ck() && !this.func_184207_aI() && !p_230254_1_.func_226563_dT_()) {
            if (!this.field_70170_p.field_72995_K) {
                p_230254_1_.func_184220_m((Entity)this);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        ActionResultType actionresulttype = super.func_230254_b_(p_230254_1_, p_230254_2_);
        if (!actionresulttype.func_226246_a_()) {
            ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
            return itemstack.func_77973_b() == Items.field_151141_av ? itemstack.func_111282_a_(p_230254_1_, (LivingEntity)this, p_230254_2_) : ActionResultType.PASS;
        }
        return actionresulttype;
    }

    public boolean func_230264_L__() {
        return this.func_70089_S() && !this.func_70631_g_();
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.func_110257_ck()) {
            this.func_199703_a((IItemProvider)Items.field_151141_av);
        }
    }

    public boolean func_110257_ck() {
        return this.steering.func_233620_b_();
    }

    public void func_230266_a_(@Nullable SoundCategory p_230266_1_) {
        this.steering.func_233619_a_(true);
        if (p_230266_1_ != null) {
            this.field_70170_p.func_217384_a((PlayerEntity)null, (Entity)this, SoundEvents.field_187706_dO, p_230266_1_, 0.5f, 1.0f);
        }
    }

    public Vector3d func_230268_c_(LivingEntity p_230268_1_) {
        Direction direction = this.func_184172_bi();
        if (direction.func_176740_k() == Direction.Axis.Y) {
            return super.func_230268_c_(p_230268_1_);
        }
        int[][] aint = TransportationHelper.func_234632_a_((Direction)direction);
        BlockPos blockpos = this.func_233580_cy_();
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Pose pose : p_230268_1_.func_230297_ef_()) {
            AxisAlignedBB axisalignedbb = p_230268_1_.func_233648_f_(pose);
            for (int[] aint1 : aint) {
                Vector3d vector3d;
                blockpos$mutable.func_181079_c(blockpos.func_177958_n() + aint1[0], blockpos.func_177956_o(), blockpos.func_177952_p() + aint1[1]);
                double d0 = this.field_70170_p.func_242403_h((BlockPos)blockpos$mutable);
                if (!TransportationHelper.func_234630_a_((double)d0) || !TransportationHelper.func_234631_a_((ICollisionReader)this.field_70170_p, (LivingEntity)p_230268_1_, (AxisAlignedBB)axisalignedbb.func_191194_a(vector3d = Vector3d.func_237490_a_((Vector3i)blockpos$mutable, (double)d0)))) continue;
                p_230268_1_.func_213301_b(pose);
                return vector3d;
            }
        }
        return super.func_230268_c_(p_230268_1_);
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        this.func_233622_a_((MobEntity)this, this.steering, p_213352_1_);
    }

    public float func_230265_N__() {
        return (float)this.func_233637_b_(Attributes.field_233821_d_) * 0.225f;
    }

    public void func_230267_a__(Vector3d p_230267_1_) {
        super.func_213352_e(p_230267_1_);
    }

    public boolean func_184762_da() {
        return this.steering.func_233617_a_(this.func_70681_au());
    }

    public SnowPigEntity getBreedOffspring(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return (SnowPigEntity)((EntityType)EntityTypeRegistry.SNOW_PIG.get()).func_200721_a((World)p_241840_1_);
    }

    public boolean func_70877_b(ItemStack p_70877_1_) {
        return FOOD_ITEMS.test(p_70877_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, (double)(0.6f * this.func_70047_e()), (double)(this.func_213311_cf() * 0.4f));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

